/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.security.AccessControlException;
import java.util.Set;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.PlainTextTokenMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TokenMakerFactory {
    public static final String PROPERTY_DEFAULT_TOKEN_MAKER_FACTORY = "TokenMakerFactory";
    private static TokenMakerFactory DEFAULT_INSTANCE;

    public static synchronized TokenMakerFactory getDefaultInstance() {
        if (DEFAULT_INSTANCE == null) {
            String clazz2 = null;
            try {
                clazz2 = System.getProperty(PROPERTY_DEFAULT_TOKEN_MAKER_FACTORY);
            }
            catch (AccessControlException ace) {
                clazz2 = null;
            }
            if (clazz2 == null) {
                clazz2 = "org.fife.ui.rsyntaxtextarea.DefaultTokenMakerFactory";
            }
            try {
                DEFAULT_INSTANCE = (TokenMakerFactory)Class.forName(clazz2).newInstance();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalError("Cannot find TokenMakerFactory: " + clazz2);
            }
        }
        return DEFAULT_INSTANCE;
    }

    public final TokenMaker getTokenMaker(String key) {
        TokenMaker tm = this.getTokenMakerImpl(key);
        if (tm == null) {
            tm = new PlainTextTokenMaker();
        }
        return tm;
    }

    protected abstract TokenMaker getTokenMakerImpl(String var1);

    public abstract Set<String> keySet();

    public static synchronized void setDefaultInstance(TokenMakerFactory tmf) {
        if (tmf == null) {
            throw new IllegalArgumentException("tmf cannot be null");
        }
        DEFAULT_INSTANCE = tmf;
    }
}

